/*
 * Decompiled with CFR 0.152.
 */
package com.turikhay.tlauncher.ui.swing;

import com.turikhay.tlauncher.ui.loc.Localizable;
import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import net.minecraft.launcher.updater.VersionSyncInfo;
import net.minecraft.launcher.versions.ReleaseType;

public class VersionCellRenderer
implements ListCellRenderer<VersionSyncInfo> {
    public static final VersionSyncInfo LOADING = VersionSyncInfo.createEmpty();
    public static final VersionSyncInfo EMPTY = VersionSyncInfo.createEmpty();
    protected final DefaultListCellRenderer defaultRenderer = new DefaultListCellRenderer();

    @Override
    public Component getListCellRendererComponent(JList<? extends VersionSyncInfo> list, VersionSyncInfo value, int index, boolean isSelected, boolean cellHasFocus) {
        JLabel renderer = (JLabel)this.defaultRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        renderer.setAlignmentY(0.5f);
        if (value == null) {
            renderer.setText("(null)");
        } else if (value.equals(LOADING)) {
            renderer.setText(Localizable.get("versions.loading"));
        } else if (value.equals(EMPTY)) {
            renderer.setText(Localizable.get("versions.notfound.tip"));
        } else {
            ReleaseType type = value.getLatestVersion().getReleaseType();
            String id = value.getID();
            String label = Localizable.nget("version." + (Object)((Object)type));
            switch (value.getLatestVersion().getReleaseType()) {
                case OLD_ALPHA: {
                    id = id.startsWith("a") ? id.substring(1) : id;
                    break;
                }
                case OLD_BETA: {
                    id = id.substring(1);
                    break;
                }
            }
            String text = label != null ? String.valueOf(label) + " " + id : id;
            renderer.setText(text);
        }
        return renderer;
    }
}

