/*
 * Decompiled with CFR 0.152.
 */
package com.turikhay.tlauncher.ui.swing.extended;

import com.turikhay.tlauncher.ui.block.BlockableLayeredPane;
import java.awt.Component;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;

public abstract class ExtendedLayeredPane
extends BlockableLayeredPane {
    private static final long serialVersionUID = -1L;
    private Integer LAYER_COUNT = 0;
    protected final Component parent;

    protected ExtendedLayeredPane() {
        this.parent = null;
    }

    public ExtendedLayeredPane(Component parent) {
        this.parent = parent;
        if (parent == null) {
            return;
        }
        parent.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent e) {
                ExtendedLayeredPane.this.onResize();
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentShown(ComponentEvent e) {
                ExtendedLayeredPane.this.onResize();
            }

            @Override
            public void componentHidden(ComponentEvent e) {
            }
        });
    }

    @Override
    public Component add(Component comp) {
        Integer n = this.LAYER_COUNT;
        this.LAYER_COUNT = n + 1;
        super.add(comp, n);
        return comp;
    }

    public void add(Component ... components) {
        if (components == null) {
            throw new NullPointerException();
        }
        Component[] componentArray = components;
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            Component comp = componentArray[n2];
            this.add(comp);
            ++n2;
        }
    }

    public void onResize() {
        if (this.parent == null) {
            return;
        }
        this.setBounds(0, 0, this.parent.getWidth(), this.parent.getHeight());
        Component[] componentArray = this.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component comp = componentArray[n2];
            if (comp instanceof ExtendedLayeredPane) {
                ((ExtendedLayeredPane)comp).onResize();
            }
            ++n2;
        }
    }
}

