/*
 * Decompiled with CFR 0.152.
 */
package com.turikhay.tlauncher.updater;

import com.turikhay.tlauncher.Bootstrapper;
import com.turikhay.tlauncher.TLauncher;
import com.turikhay.tlauncher.configuration.SimpleConfiguration;
import com.turikhay.tlauncher.downloader.Downloadable;
import com.turikhay.tlauncher.downloader.Downloader;
import com.turikhay.tlauncher.handlers.DownloadableHandler;
import com.turikhay.tlauncher.updater.PackageType;
import com.turikhay.tlauncher.updater.UpdateListener;
import com.turikhay.tlauncher.updater.Updater;
import com.turikhay.util.U;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Update {
    public static final int NONE = 0;
    public static final int DOWNLOADING = 1;
    public static final int DOWNLOADED = 2;
    public static final int UPDATING = 3;
    private int step;
    private double version;
    private String description;
    private Map<PackageType, URI> links = new HashMap<PackageType, URI>();
    private final Updater upd;
    private final Downloader d;
    private boolean isDownloading;
    private List<UpdateListener> listeners = Collections.synchronizedList(new ArrayList());

    public void addListener(UpdateListener l) {
        this.listeners.add(l);
    }

    public void removeListener(UpdateListener l) {
        this.listeners.remove(l);
    }

    Update(Updater upd, Downloader d, double version, String description) {
        if (upd == null) {
            throw new NullPointerException("Updater is NULL!");
        }
        if (d == null) {
            throw new NullPointerException("Downloader is NULL!");
        }
        this.upd = upd;
        this.d = d;
        this.setVersion(version);
        this.setDescription(description);
    }

    Update(Updater upd, Downloader d, SimpleConfiguration settings) {
        if (upd == null) {
            throw new NullPointerException("Updater is NULL!");
        }
        if (d == null) {
            throw new NullPointerException("Downloader is NULL!");
        }
        if (settings == null) {
            throw new NullPointerException("Settings is NULL!");
        }
        this.upd = upd;
        this.d = d;
        this.setVersion(settings.getDouble("latest"));
        this.setDescription(settings.get("description"));
        for (String key : settings.getKeys()) {
            try {
                this.links.put(PackageType.valueOf(key.toUpperCase()), U.makeURI(settings.get(key)));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Update.log("An update available for packages:", this.links.keySet());
    }

    public Updater getUpdater() {
        return this.upd;
    }

    public URI getDownloadLinkFor(PackageType pt) {
        return this.links.get((Object)pt);
    }

    public URI getDownloadLink() {
        return this.getDownloadLinkFor(PackageType.getCurrent());
    }

    public double getVersion() {
        return this.version;
    }

    public String getDescription() {
        return this.description;
    }

    public int getStep() {
        return this.step;
    }

    public void download(boolean async) {
        this.downloadFor(PackageType.getCurrent(), async);
    }

    public void download() {
        this.download(false);
    }

    public void asyncDownload() {
        this.download(true);
    }

    public void downloadFor(PackageType pt, boolean async) {
        try {
            this.downloadFor_(pt, async);
        }
        catch (Exception e) {
            this.onUpdateError(e);
        }
    }

    private void downloadFor_(PackageType pt, boolean async) throws Exception {
        if (this.step > 0) {
            throw new IllegalStepException(this.step);
        }
        URI download_link = this.getDownloadLinkFor(pt);
        if (download_link == null) {
            throw new NullPointerException("Update for package \"" + (Object)((Object)pt) + "\" is not found");
        }
        File destination = Updater.getUpdateFileFor(pt);
        destination.deleteOnExit();
        final Downloadable downloadable = new Downloadable(download_link.toURL(), destination);
        downloadable.addHandler(new DownloadableHandler(){

            @Override
            public void onStart() {
            }

            @Override
            public void onCompleteError() {
                Update.this.isDownloading = false;
                Update.this.step = 0;
                Update.this.onUpdateDownloadError(downloadable.getError());
            }

            @Override
            public void onComplete() {
                Update.this.isDownloading = false;
                Update.this.step = 2;
                Update.this.onUpdateReady();
            }

            @Override
            public void onAbort() {
                Update.this.isDownloading = false;
                Update.this.step = 0;
            }
        });
        this.onUpdateDownloading();
        this.isDownloading = true;
        this.d.add(downloadable);
        this.d.startLaunch();
        if (!async) {
            while (this.isDownloading) {
                U.sleepFor(1000L);
            }
        }
    }

    public void apply() {
        this.applyFor(PackageType.getCurrent());
    }

    public void applyFor(PackageType pt) {
        try {
            this.applyFor_(pt);
        }
        catch (Exception e) {
            this.onUpdateApplyError(e);
        }
    }

    private void applyFor_(PackageType pt) throws Exception {
        if (this.step < 2) {
            throw new IllegalStepException(this.step);
        }
        Update.log("Saving update... Launcher will be reopened.");
        File replace = Updater.getFileFor(pt);
        File replacer = Updater.getUpdateFileFor(pt);
        replacer.deleteOnExit();
        String[] args = TLauncher.getInstance() != null ? TLauncher.getArgs() : new String[]{};
        ProcessBuilder builder = Bootstrapper.buildProcess(args);
        FileInputStream in = new FileInputStream(replacer);
        FileOutputStream out = new FileOutputStream(replace);
        this.onUpdateApplying();
        byte[] buffer = new byte[65536];
        int curread = in.read(buffer);
        while (curread > 0) {
            out.write(buffer, 0, curread);
            curread = in.read(buffer);
        }
        in.close();
        out.close();
        try {
            builder.start();
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.exit(0);
    }

    void setVersion(double v) {
        if (v <= 0.0) {
            throw new IllegalArgumentException("Invalid version!");
        }
        this.version = v;
    }

    void setDescription(String desc) {
        this.description = desc;
    }

    void setLinkFor(PackageType pt, URI link) {
        if (pt == null) {
            throw new NullPointerException("PackageType is NULL!");
        }
        if (link == null) {
            throw new NullPointerException("URI is NULL!");
        }
        if (this.links.containsKey((Object)pt)) {
            this.links.remove((Object)pt);
        }
        this.links.put(pt, link);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onUpdateError(Throwable e) {
        List<UpdateListener> list = this.listeners;
        synchronized (list) {
            for (UpdateListener l : this.listeners) {
                l.onUpdateError(this, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onUpdateDownloading() {
        List<UpdateListener> list = this.listeners;
        synchronized (list) {
            for (UpdateListener l : this.listeners) {
                l.onUpdateDownloading(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onUpdateDownloadError(Throwable e) {
        List<UpdateListener> list = this.listeners;
        synchronized (list) {
            for (UpdateListener l : this.listeners) {
                l.onUpdateDownloadError(this, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onUpdateReady() {
        List<UpdateListener> list = this.listeners;
        synchronized (list) {
            for (UpdateListener l : this.listeners) {
                l.onUpdateReady(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onUpdateApplying() {
        List<UpdateListener> list = this.listeners;
        synchronized (list) {
            for (UpdateListener l : this.listeners) {
                l.onUpdateApplying(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onUpdateApplyError(Throwable e) {
        U.log("Apply error");
        List<UpdateListener> list = this.listeners;
        synchronized (list) {
            U.log(e);
            for (UpdateListener l : this.listeners) {
                l.onUpdateApplyError(this, e);
            }
        }
    }

    private static void log(Object ... obj) {
        U.log("[Updater]", obj);
    }

    private static String getMessageForStep(int step, String description) {
        String r = "Illegal action on step #" + step;
        if (description != null) {
            r = String.valueOf(r) + " : " + description;
        }
        return r;
    }

    public class IllegalStepException
    extends RuntimeException {
        private static final long serialVersionUID = -1988019882288031411L;

        IllegalStepException(int step, String description) {
            super(Update.getMessageForStep(step, description));
        }

        IllegalStepException(int step) {
            super(Update.getMessageForStep(step, null));
        }
    }
}

