/*
 * Decompiled with CFR 0.152.
 */
package com.turikhay.tlauncher.updater;

import com.turikhay.tlauncher.TLauncher;
import com.turikhay.tlauncher.configuration.SimpleConfiguration;
import com.turikhay.tlauncher.downloader.Downloadable;
import com.turikhay.tlauncher.downloader.Downloader;
import com.turikhay.tlauncher.exceptions.TLauncherException;
import com.turikhay.tlauncher.updater.Ad;
import com.turikhay.tlauncher.updater.PackageType;
import com.turikhay.tlauncher.updater.Update;
import com.turikhay.tlauncher.updater.UpdaterListener;
import com.turikhay.util.FileUtil;
import com.turikhay.util.U;
import com.turikhay.util.async.AsyncThread;
import java.io.File;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Updater {
    public static final String[] links = TLauncher.getUpdateRepos();
    public static final URI[] URIs = Updater.makeURIs();
    private final Downloader d;
    private List<UpdaterListener> listeners = Collections.synchronizedList(new ArrayList());
    private Update found;
    private SimpleConfiguration parsed;
    private UpdaterState state;

    public void addListener(UpdaterListener l) {
        this.listeners.add(l);
    }

    public void removeListener(UpdaterListener l) {
        this.listeners.remove(l);
    }

    public Updater(Downloader d) {
        File oldfile;
        this.d = d;
        if (!PackageType.isCurrent(PackageType.JAR) && (oldfile = Updater.getTempFile()).delete()) {
            Updater.log("Old version has been deleted (.update)");
        }
        Updater.log("Initialized.");
        Updater.log(new Object[]{"Package type:", PackageType.getCurrent()});
    }

    public Updater(TLauncher t) {
        this(t.getDownloader());
    }

    public UpdaterState getState() {
        return this.state;
    }

    public UpdaterState findUpdate() {
        try {
            this.state = this.findUpdate_();
            return this.state;
        }
        catch (Throwable e) {
            this.state = UpdaterState.ERROR;
            return this.state;
        }
    }

    private UpdaterState findUpdate_() {
        Updater.log("Requesting an update...");
        this.onUpdaterRequests();
        int attempt = 0;
        URI[] uRIArray = URIs;
        int n = URIs.length;
        int n2 = 0;
        while (n2 < n) {
            URI uri = uRIArray[n2];
            Updater.log("Attempt #" + ++attempt + ". URL:", uri);
            try {
                Downloadable downloadable = new Downloadable(uri.toURL());
                HttpURLConnection connection = downloadable.makeConnection();
                int code = connection.getResponseCode();
                switch (code) {
                    case 200: {
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Response code (" + code + ") is not supported by Updater!");
                    }
                }
                InputStream is = connection.getInputStream();
                this.parsed = new SimpleConfiguration(is);
                connection.disconnect();
                Update update = new Update(this, this.d, this.parsed);
                double version = update.getVersion();
                Updater.log("Success!");
                if (TLauncher.getVersion() > version) {
                    Updater.log("Found version is older than running:", version, "(" + TLauncher.getVersion() + ")");
                }
                if (update.getDownloadLink() == null) {
                    Updater.log("An update for current package type is not available.");
                } else if (TLauncher.getVersion() < version) {
                    Updater.log("Found actual version:", version);
                    this.found = update;
                    this.onUpdateFound(update);
                    return UpdaterState.FOUND;
                }
                Ad ad = new Ad(this.parsed);
                if (ad.canBeShown()) {
                    this.onAdFound(ad);
                }
                this.noUpdateFound();
                return UpdaterState.NOT_FOUND;
            }
            catch (Exception e) {
                Updater.log("Cannot get update information", e);
                ++n2;
            }
        }
        Updater.log("Updating is impossible - cannot get any information.");
        this.onUpdaterRequestError();
        return UpdaterState.ERROR;
    }

    public void notifyAboutUpdate() {
        if (this.found == null) {
            return;
        }
        this.onUpdateFound(this.found);
    }

    public Update getUpdate() {
        return this.found;
    }

    public SimpleConfiguration getParsed() {
        return this.parsed;
    }

    public void asyncFindUpdate() {
        AsyncThread.execute(new Runnable(){

            @Override
            public void run() {
                Updater.this.findUpdate();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onUpdaterRequests() {
        List<UpdaterListener> list = this.listeners;
        synchronized (list) {
            for (UpdaterListener l : this.listeners) {
                l.onUpdaterRequesting(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onUpdaterRequestError() {
        List<UpdaterListener> list = this.listeners;
        synchronized (list) {
            for (UpdaterListener l : this.listeners) {
                l.onUpdaterRequestError(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onUpdateFound(Update u) {
        List<UpdaterListener> list = this.listeners;
        synchronized (list) {
            for (UpdaterListener l : this.listeners) {
                l.onUpdateFound(u);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void noUpdateFound() {
        List<UpdaterListener> list = this.listeners;
        synchronized (list) {
            for (UpdaterListener l : this.listeners) {
                l.onUpdaterNotFoundUpdate(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onAdFound(Ad ad) {
        List<UpdaterListener> list = this.listeners;
        synchronized (list) {
            for (UpdaterListener l : this.listeners) {
                l.onAdFound(this, ad);
            }
        }
    }

    public static boolean isAutomodeFor(PackageType pt) {
        if (pt == null) {
            throw new NullPointerException("PackageType is NULL!");
        }
        switch (pt) {
            case EXE: 
            case JAR: {
                return true;
            }
        }
        throw new IllegalArgumentException("Unknown PackageType!");
    }

    public static boolean isAutomode() {
        return Updater.isAutomodeFor(PackageType.getCurrent());
    }

    public static File getFileFor(PackageType pt) {
        if (pt == null) {
            throw new NullPointerException("PackageType is NULL!");
        }
        switch (pt) {
            case EXE: 
            case JAR: {
                return FileUtil.getRunningJar();
            }
        }
        throw new IllegalArgumentException("Unknown PackageType!");
    }

    public static File getFile() {
        return Updater.getFileFor(PackageType.getCurrent());
    }

    public static File getUpdateFileFor(PackageType pt) {
        return new File(String.valueOf(Updater.getFileFor(pt).getAbsolutePath()) + ".update");
    }

    public static File getUpdateFile() {
        return Updater.getUpdateFileFor(PackageType.getCurrent());
    }

    public static File getTempFileFor(PackageType pt) {
        return new File(String.valueOf(Updater.getFileFor(pt).getAbsolutePath()) + ".replace");
    }

    public static File getTempFile() {
        return Updater.getTempFileFor(PackageType.getCurrent());
    }

    private static URI[] makeURIs() {
        int len = links.length;
        URI[] r = new URI[len];
        int i = 0;
        while (i < len) {
            try {
                r[i] = new URL(links[i]).toURI();
            }
            catch (Exception e) {
                throw new TLauncherException("Cannot create link from at i:" + i, e);
            }
            ++i;
        }
        return r;
    }

    private static void log(Object ... obj) {
        U.log("[Updater]", obj);
    }

    public static enum UpdaterState {
        READY,
        FOUND,
        NOT_FOUND,
        ERROR;

    }
}

