/*
 * Decompiled with CFR 0.152.
 */
package com.turikhay.util;

import com.turikhay.util.U;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class FileUtil {
    public static final String DEFAULT_CHARSET = "UTF-8";

    public static Charset getCharset() {
        try {
            return Charset.forName(DEFAULT_CHARSET);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void writeFile(File file, String text) throws IOException {
        FileUtil.createFile(file);
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file));
        OutputStreamWriter ow = new OutputStreamWriter((OutputStream)os, DEFAULT_CHARSET);
        ow.write(text);
        ow.close();
        os.close();
    }

    public static String readFile(File file, String charset) throws IOException {
        if (file == null) {
            throw new NullPointerException("File is NULL!");
        }
        if (!file.exists()) {
            return null;
        }
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));
        InputStreamReader reader = new InputStreamReader((InputStream)bis, charset);
        StringBuilder b = new StringBuilder();
        while (reader.ready()) {
            b.append((char)reader.read());
        }
        reader.close();
        bis.close();
        return b.toString();
    }

    public static String readFile(File file) throws IOException {
        return FileUtil.readFile(file, DEFAULT_CHARSET);
    }

    public static String getFilename(URL url) {
        String inServer = url.getPath();
        String[] folders = inServer.split("/");
        int size = folders.length;
        if (size == 0) {
            return "";
        }
        return folders[size - 1];
    }

    public static String getDigest(File file, String algorithm, int hashLength) {
        DigestInputStream stream = null;
        try {
            try {
                int read;
                stream = new DigestInputStream(new FileInputStream(file), MessageDigest.getInstance(algorithm));
                byte[] buffer = new byte[65536];
                while ((read = stream.read(buffer)) > 0) {
                }
            }
            catch (Exception ignored) {
                FileUtil.close(stream);
                return null;
            }
        }
        catch (Throwable throwable) {
            FileUtil.close(stream);
            throw throwable;
        }
        FileUtil.close(stream);
        return String.format("%1$0" + hashLength + "x", new BigInteger(1, stream.getMessageDigest().digest()));
    }

    public static String copyAndDigest(InputStream inputStream, OutputStream outputStream, String algorithm, int hashLength) throws IOException {
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Missing Digest. " + algorithm, e);
        }
        byte[] buffer = new byte[65536];
        try {
            int read = inputStream.read(buffer);
            while (read >= 1) {
                digest.update(buffer, 0, read);
                outputStream.write(buffer, 0, read);
                read = inputStream.read(buffer);
            }
        }
        finally {
            FileUtil.close(inputStream);
            FileUtil.close(outputStream);
        }
        return String.format("%1$0" + hashLength + "x", new BigInteger(1, digest.digest()));
    }

    /*
     * Loose catch block
     */
    public static byte[] createChecksum(File file, String algorithm) {
        byte[] byArray;
        BufferedInputStream fis = null;
        try {
            int numRead;
            fis = new BufferedInputStream(new FileInputStream(file));
            byte[] buffer = new byte[1024];
            MessageDigest complete = MessageDigest.getInstance(algorithm);
            do {
                if ((numRead = ((InputStream)fis).read(buffer)) <= 0) continue;
                complete.update(buffer, 0, numRead);
            } while (numRead != -1);
            byArray = complete.digest();
        }
        catch (Exception e) {
            FileUtil.close(fis);
            return null;
            catch (Throwable throwable) {
                FileUtil.close(fis);
                throw throwable;
            }
        }
        FileUtil.close(fis);
        return byArray;
    }

    public static String getChecksum(File file, String algorithm) {
        if (file == null) {
            return null;
        }
        if (!file.exists()) {
            return null;
        }
        byte[] b = FileUtil.createChecksum(file, algorithm);
        if (b == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        byte[] byArray = b;
        int n = b.length;
        int n2 = 0;
        while (n2 < n) {
            byte cb = byArray[n2];
            result.append(Integer.toString((cb & 0xFF) + 256, 16).substring(1));
            ++n2;
        }
        return result.toString();
    }

    public static void close(Closeable a) {
        try {
            a.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static File getRunningJar() {
        try {
            return new File(URLDecoder.decode(FileUtil.class.getProtectionDomain().getCodeSource().getLocation().getPath(), DEFAULT_CHARSET));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Cannot get running file!", e);
        }
    }

    public static void copyFile(File source, File dest, boolean replace) throws IOException {
        if (dest.exists()) {
            if (!replace) {
                return;
            }
        } else {
            dest.createNewFile();
        }
        InputStream is = null;
        OutputStream os = null;
        try {
            int length;
            is = new BufferedInputStream(new FileInputStream(source));
            os = new BufferedOutputStream(new FileOutputStream(dest));
            byte[] buffer = new byte[1024];
            while ((length = is.read(buffer)) > 0) {
                os.write(buffer, 0, length);
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (os != null) {
                os.close();
            }
        }
    }

    public static void deleteFile(File file) {
        if (!file.delete()) {
            file.deleteOnExit();
        }
    }

    public static void deleteFile(String path) {
        File file = new File(path);
        if (!file.delete()) {
            file.deleteOnExit();
        }
    }

    public static File makeTemp(File file) throws IOException {
        FileUtil.createFile(file);
        file.deleteOnExit();
        return file;
    }

    public byte[] getFile(File archive, String requestedFile) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ZipInputStream in = null;
        try {
            ZipEntry entry;
            in = new ZipInputStream(new FileInputStream(archive));
            while ((entry = in.getNextEntry()) != null) {
                int len;
                if (!entry.getName().equals(requestedFile)) continue;
                byte[] buf = new byte[1024];
                while ((len = in.read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
            out.close();
        }
        return out.toByteArray();
    }

    public static boolean createFolder(File dir) throws IOException {
        if (dir == null) {
            throw new NullPointerException();
        }
        if (dir.isDirectory()) {
            return false;
        }
        if (!dir.mkdirs()) {
            throw new IOException("Cannot create folders: " + dir);
        }
        return true;
    }

    public static boolean createFolder(String dir) throws IOException {
        if (dir == null) {
            return false;
        }
        return FileUtil.createFolder(new File(dir));
    }

    public static boolean folderExists(String path) {
        if (path == null) {
            return false;
        }
        File folder = new File(path);
        return folder.isDirectory();
    }

    public static boolean fileExists(String path) {
        if (path == null) {
            return false;
        }
        File file = new File(path);
        return file.isFile();
    }

    public static boolean createFile(File file) throws IOException {
        if (file.isFile()) {
            return false;
        }
        if (file.getParentFile() != null) {
            file.getParentFile().mkdirs();
        }
        return file.createNewFile();
    }

    public static boolean createFile(String file) throws IOException {
        return FileUtil.createFile(new File(file));
    }

    public static void unZip(File zip, File folder, boolean replace) throws IOException {
        ZipEntry ze;
        FileUtil.createFolder(folder);
        ZipInputStream zis = new ZipInputStream(new BufferedInputStream(new FileInputStream(zip)));
        byte[] buffer = new byte[1024];
        while ((ze = zis.getNextEntry()) != null) {
            int len;
            String fileName = ze.getName();
            File newFile = new File(folder, fileName);
            if (!replace && newFile.isFile()) {
                U.log("[UnZip] File exists:", newFile.getAbsoluteFile());
                continue;
            }
            U.log("[UnZip]", newFile.getAbsoluteFile());
            FileUtil.createFile(newFile);
            BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(newFile));
            while ((len = zis.read(buffer)) > 0) {
                ((OutputStream)fos).write(buffer, 0, len);
            }
            ((OutputStream)fos).close();
        }
        zis.closeEntry();
        zis.close();
    }

    public static void removeFromZip(File zipFile, List<String> files) throws IOException {
        File tempFile = File.createTempFile(zipFile.getName(), null);
        tempFile.delete();
        tempFile.deleteOnExit();
        boolean renameOk = zipFile.renameTo(tempFile);
        if (!renameOk) {
            throw new IOException("Could not rename the file " + zipFile.getAbsolutePath() + " to " + tempFile.getAbsolutePath());
        }
        byte[] buf = new byte[1024];
        ZipInputStream zin = new ZipInputStream(new BufferedInputStream(new FileInputStream(tempFile)));
        ZipOutputStream zout = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(zipFile)));
        ZipEntry entry = zin.getNextEntry();
        while (entry != null) {
            String name = entry.getName();
            if (!files.contains(name)) {
                int len;
                zout.putNextEntry(new ZipEntry(name));
                while ((len = zin.read(buf)) > 0) {
                    zout.write(buf, 0, len);
                }
            }
            entry = zin.getNextEntry();
        }
        zin.close();
        zout.close();
        tempFile.delete();
    }

    public static String getResource(URL resource, String charset) throws IOException {
        BufferedInputStream is = new BufferedInputStream(resource.openStream());
        InputStreamReader reader = new InputStreamReader((InputStream)is, charset);
        StringBuilder b = new StringBuilder();
        while (reader.ready()) {
            b.append((char)reader.read());
        }
        reader.close();
        return b.toString();
    }

    public static String getResource(URL resource) throws IOException {
        return FileUtil.getResource(resource, DEFAULT_CHARSET);
    }

    public static String getFolder(URL url, String separator) {
        String[] folders = url.toString().split(separator);
        String s = "";
        int i = 0;
        while (i < folders.length - 1) {
            s = String.valueOf(s) + folders[i] + separator;
            ++i;
        }
        return s;
    }

    public static String getFolder(URL url) {
        return FileUtil.getFolder(url, "/");
    }

    public static File getNeighborFile(File file, String filename) {
        File parent = file.getParentFile();
        if (parent == null) {
            parent = new File("/");
        }
        return new File(parent, filename);
    }

    public static File getNeighborFile(String filename) {
        return FileUtil.getNeighborFile(FileUtil.getRunningJar(), filename);
    }
}

