/*
 * Decompiled with CFR 0.152.
 */
package com.turikhay.util;

import com.turikhay.tlauncher.exceptions.ParseException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;

public class StringUtil {
    public static String addQuotes(String a, char quote) {
        if (a == null) {
            return null;
        }
        if (a.length() == 0) {
            return "";
        }
        return String.valueOf(quote) + a.replaceAll("\\" + quote, "\\\\" + quote) + quote;
    }

    public static String addQuotes(String a) {
        return StringUtil.addQuotes(a, '\"');
    }

    public static String addSlashes(String str, EscapeGroup group) {
        if (str == null) {
            return "";
        }
        StringBuffer s = new StringBuffer(str);
        int i = 0;
        while (i < s.length()) {
            char[] cArray = group.getChars();
            int n = cArray.length;
            int n2 = 0;
            while (n2 < n) {
                char c = cArray[n2];
                if (s.charAt(i) == c) {
                    s.insert(i++, '\\');
                }
                ++n2;
            }
            ++i;
        }
        return s.toString();
    }

    public static String[] addSlashes(String[] str, EscapeGroup group) {
        if (str == null) {
            return null;
        }
        int len = str.length;
        String[] ret = new String[len];
        int i = 0;
        while (i < len) {
            ret[i] = StringUtil.addSlashes(str[i], group);
            ++i;
        }
        return ret;
    }

    public static String iconv(String inChar, String outChar, String str) {
        Charset in = Charset.forName(inChar);
        Charset out = Charset.forName(outChar);
        CharsetDecoder decoder = in.newDecoder();
        CharsetEncoder encoder = out.newEncoder();
        try {
            ByteBuffer bbuf = encoder.encode(CharBuffer.wrap(str));
            CharBuffer cbuf = decoder.decode(bbuf);
            return cbuf.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean parseBoolean(String b) throws ParseException {
        if (b == null) {
            throw new ParseException("String cannot be NULL!");
        }
        if (b.equalsIgnoreCase("true")) {
            return true;
        }
        if (b.equalsIgnoreCase("false")) {
            return false;
        }
        throw new ParseException("Cannot parse value (" + b + ")!");
    }

    public static int countLines(String str) {
        if (str == null || str.length() == 0) {
            return 0;
        }
        int lines = 1;
        int len = str.length();
        int pos = 0;
        while (pos < len) {
            char c = str.charAt(pos);
            if (c == '\r') {
                ++lines;
                if (pos + 1 < len && str.charAt(pos + 1) == '\n') {
                    ++pos;
                }
            } else if (c == '\n') {
                ++lines;
            }
            ++pos;
        }
        return lines;
    }

    public static char lastChar(String str) {
        if (str == null) {
            throw new NullPointerException();
        }
        int len = str.length();
        if (len == 0) {
            return '\u0000';
        }
        if (len == 1) {
            return str.charAt(0);
        }
        return str.charAt(len - 1);
    }

    public static enum EscapeGroup {
        COMMAND('\'', '\"', ' '),
        REGEXP(COMMAND, '/', '\\', '?', '*', '+', '[', ']', ':', '{', '}', '(', ')');

        private final char[] chars;

        private EscapeGroup(char ... symbols) {
            this.chars = symbols;
        }

        private EscapeGroup(EscapeGroup extend, char ... symbols) {
            int len = extend.chars.length + symbols.length;
            this.chars = new char[len];
            int x = 0;
            while (x < extend.chars.length) {
                this.chars[x] = extend.chars[x];
                ++x;
            }
            int i = 0;
            while (i < symbols.length) {
                this.chars[i + x] = symbols[i];
                ++i;
            }
        }

        public char[] getChars() {
            return this.chars;
        }
    }
}

