/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher;

import com.turikhay.util.FileUtil;
import com.turikhay.util.U;
import java.awt.Desktop;
import java.io.File;
import java.net.URI;

public enum OperatingSystem {
    LINUX("linux", new String[]{"linux", "unix"}),
    WINDOWS("windows", new String[]{"win"}),
    OSX("osx", new String[]{"mac"}),
    SOLARIS("solaris", new String[]{"solaris", "sunos"}),
    UNKNOWN("unknown", new String[0]);

    private final String name;
    private final String[] aliases;
    private final String arch = System.getProperty("sun.arch.data.model");

    private OperatingSystem(String name, String[] aliases) {
        this.name = name;
        this.aliases = aliases == null ? new String[]{} : aliases;
    }

    public String getName() {
        return this.name;
    }

    public String[] getAliases() {
        return this.aliases;
    }

    public boolean isSupported() {
        return this != UNKNOWN;
    }

    public String getJavaDir(boolean appendFile) {
        String separator = System.getProperty("file.separator");
        String path = String.valueOf(System.getProperty("java.home")) + separator;
        if (appendFile) {
            path = String.valueOf(path) + "bin" + separator;
            if (OperatingSystem.getCurrentPlatform() == WINDOWS) {
                return String.valueOf(path) + "javaw.exe";
            }
            return String.valueOf(path) + "java";
        }
        return path;
    }

    public String getJavaDir() {
        return this.getJavaDir(true);
    }

    public boolean doesJavaExist() {
        return this == WINDOWS ? FileUtil.fileExists(this.getJavaDir()) : FileUtil.folderExists(this.getJavaDir());
    }

    public static OperatingSystem getCurrentPlatform() {
        String osName = System.getProperty("os.name").toLowerCase();
        OperatingSystem[] operatingSystemArray = OperatingSystem.values();
        int n = operatingSystemArray.length;
        int n2 = 0;
        while (n2 < n) {
            OperatingSystem os = operatingSystemArray[n2];
            String[] stringArray = os.getAliases();
            int n3 = stringArray.length;
            int n4 = 0;
            while (n4 < n3) {
                String alias = stringArray[n4];
                if (osName.contains(alias)) {
                    return os;
                }
                ++n4;
            }
            ++n2;
        }
        return UNKNOWN;
    }

    public boolean is32Bit() {
        return this.arch.equals("32");
    }

    public boolean is64Bit() {
        return this.arch.equals("64");
    }

    public String getArch() {
        return this.arch;
    }

    public static boolean openLink(URI link) {
        if (!Desktop.isDesktopSupported()) {
            return false;
        }
        Desktop desktop = Desktop.getDesktop();
        try {
            desktop.browse(link);
        }
        catch (Exception e) {
            U.log("Failed to open link: " + link);
            return false;
        }
        return true;
    }

    public static boolean openFile(File file) {
        if (!Desktop.isDesktopSupported()) {
            return false;
        }
        Desktop desktop = Desktop.getDesktop();
        try {
            desktop.open(file);
        }
        catch (Exception e) {
            U.log("Failed to open file: " + file);
            return false;
        }
        return true;
    }

    public int getRecommendedMemory() {
        return this.is32Bit() ? 512 : 1024;
    }

    public static String getCurrentInfo() {
        return String.valueOf(System.getProperty("os.name")) + " " + System.getProperty("os.version") + ", " + "Java " + System.getProperty("java.version");
    }
}

