/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.updater;

import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Set;
import java.util.TimeZone;
import net.minecraft.launcher.versions.ReleaseType;
import net.minecraft.launcher.versions.Version;

public class VersionFilter {
    private final Set<ReleaseType> types = new HashSet<ReleaseType>();
    private final Date oldMarker;

    public VersionFilter() {
        Collections.addAll(this.types, ReleaseType.values());
        GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        calendar.set(2013, 3, 20, 15, 0);
        this.oldMarker = calendar.getTime();
    }

    public Set<ReleaseType> getTypes() {
        return this.types;
    }

    public VersionFilter onlyForTypes(ReleaseType[] types) {
        this.types.clear();
        this.includeTypes(types);
        return this;
    }

    public VersionFilter onlyForType(ReleaseType type) {
        this.types.clear();
        this.includeType(type);
        return this;
    }

    public VersionFilter includeTypes(ReleaseType[] types) {
        if (types != null) {
            Collections.addAll(this.types, types);
        }
        return this;
    }

    public VersionFilter includeType(ReleaseType type) {
        this.types.add(type);
        return this;
    }

    public VersionFilter excludeTypes(ReleaseType[] types) {
        if (types != null) {
            ReleaseType[] releaseTypeArray = types;
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                ReleaseType type = releaseTypeArray[n2];
                this.types.remove((Object)type);
                ++n2;
            }
        }
        return this;
    }

    public VersionFilter excludeType(ReleaseType type) {
        this.types.remove((Object)type);
        return this;
    }

    public boolean satisfies(Version v) {
        boolean old;
        if (v.getReleaseType() == null) {
            return true;
        }
        Date releaseTime = v.getReleaseTime();
        boolean bl = old = !v.getReleaseType().isOld() && releaseTime != null && releaseTime.before(this.oldMarker) && releaseTime.getTime() > 0L;
        if (old) {
            return this.types.contains((Object)ReleaseType.OLD);
        }
        for (ReleaseType ct : this.types) {
            if (ct != v.getReleaseType()) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "VersionFilter" + this.types;
    }
}

