/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.versions;

import com.turikhay.tlauncher.TLauncher;
import com.turikhay.tlauncher.minecraft.repository.VersionRepository;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.launcher.OperatingSystem;
import net.minecraft.launcher.versions.ExtractRules;
import net.minecraft.launcher.versions.Rule;
import org.apache.commons.lang3.text.StrSubstitutor;

public class Library {
    private static final StrSubstitutor SUBSTITUTOR;
    private String name;
    private List<Rule> rules;
    private Map<OperatingSystem, String> natives;
    private ExtractRules extract;
    private String url;
    private String exact_url;

    static {
        HashMap<String, String> map = new HashMap<String, String>();
        OperatingSystem os = OperatingSystem.getCurrentPlatform();
        map.put("platform", os.getName());
        map.put("arch", os.getArch());
        SUBSTITUTOR = new StrSubstitutor(map);
    }

    public String getName() {
        return this.name;
    }

    public List<Rule> getRules() {
        return Collections.unmodifiableList(this.rules);
    }

    public boolean appliesToCurrentEnvironment() {
        if (this.rules == null) {
            return true;
        }
        Rule.Action lastAction = Rule.Action.DISALLOW;
        for (Rule rule : this.rules) {
            Rule.Action action = rule.getAppliedAction();
            if (action == null) continue;
            lastAction = action;
        }
        return lastAction == Rule.Action.ALLOW;
    }

    public Map<OperatingSystem, String> getNatives() {
        return this.natives;
    }

    public ExtractRules getExtractRules() {
        return this.extract;
    }

    public String getArtifactBaseDir() {
        if (this.name == null) {
            throw new IllegalStateException("Cannot get artifact dir of empty/blank artifact");
        }
        String[] parts = this.name.split(":", 3);
        return String.format("%s/%s/%s", parts[0].replaceAll("\\.", "/"), parts[1], parts[2]);
    }

    public String getArtifactPath() {
        return this.getArtifactPath(null);
    }

    public String getArtifactPath(String classifier) {
        if (this.name == null) {
            throw new IllegalStateException("Cannot get artifact path of empty/blank artifact");
        }
        return String.format("%s/%s", this.getArtifactBaseDir(), this.getArtifactFilename(classifier));
    }

    public String getArtifactFilename(String classifier) {
        if (this.name == null) {
            throw new IllegalStateException("Cannot get artifact filename of empty/blank artifact");
        }
        String[] parts = this.name.split(":", 3);
        String result = classifier == null ? String.format("%s-%s.jar", parts[1], parts[2]) : String.format("%s-%s%s.jar", parts[1], parts[2], "-" + classifier);
        return SUBSTITUTOR.replace(result);
    }

    public String toString() {
        return "Library{name='" + this.name + '\'' + ", rules=" + this.rules + ", natives=" + this.natives + ", extract=" + this.extract + '}';
    }

    public String getURL(VersionRepository source, OperatingSystem os) {
        String nativePath;
        if (this.exact_url != null) {
            return this.exact_url;
        }
        String string = nativePath = this.natives != null && this.appliesToCurrentEnvironment() ? this.natives.get((Object)os) : null;
        String download_url = this.url == null ? TLauncher.getLibraryRepo()[0] : (this.url.startsWith("/") ? String.valueOf(source.getSelectedRepo()) + this.url.substring(1) : this.url);
        return String.valueOf(download_url) + this.getArtifactPath(nativePath);
    }
}

