/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.versions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public enum ReleaseType {
    RELEASE("release", false, true),
    SNAPSHOT("snapshot"),
    OLD_BETA("old-beta"),
    OLD_ALPHA("old-alpha"),
    OLD("old"),
    MODIFIED("modified"),
    UNKNOWN("unknown", false, false);

    private static final Map<String, ReleaseType> lookup;
    private static ReleaseType[] defaultTypes;
    private final String name;
    private final boolean isDefault;
    private final boolean isDesired;

    static {
        lookup = new HashMap<String, ReleaseType>();
        ReleaseType[] releaseTypeArray = ReleaseType.values();
        int n = releaseTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ReleaseType type = releaseTypeArray[n2];
            lookup.put(type.getName(), type);
            ++n2;
        }
        ArrayList<ReleaseType> types = new ArrayList<ReleaseType>();
        ReleaseType[] releaseTypeArray2 = ReleaseType.values();
        int n3 = releaseTypeArray2.length;
        n = 0;
        while (n < n3) {
            ReleaseType type = releaseTypeArray2[n];
            if (type.isDefault) {
                types.add(type);
            }
            ++n;
        }
        defaultTypes = new ReleaseType[types.size()];
        types.toArray(defaultTypes);
    }

    private ReleaseType(String name, boolean isDefault, boolean isDesired) {
        this.name = name;
        this.isDefault = isDefault;
        this.isDesired = isDesired;
    }

    private ReleaseType(String name, boolean isDesired) {
        this(name, true, isDesired);
    }

    private ReleaseType(String name) {
        this(name, true, false);
    }

    public String getName() {
        return this.name;
    }

    public boolean isDesired() {
        return this.isDesired;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public boolean isOld() {
        return this.name.startsWith("old");
    }

    public String toString() {
        return super.toString().toLowerCase();
    }

    public static ReleaseType getByName(String name) {
        return lookup.get(name);
    }

    public static ReleaseType[] getDefinable() {
        return defaultTypes;
    }
}

